/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.dto.PmHolidayRequestDto;
import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

public class PmHolidayRequestDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE = "PM_HOLIDAYREQUEST"	;
	public static final String KEY_1 = "ROUTEID"				;	//[gID

	// 
	public static final String COL_ROUTE_ID		= "ROUTEID"		;	//[gID
	public static final String COL_S_CODE			= "SCODE"		;	//R[h
	public static final String COL_K_CODE			= "KCODE"		;	//ЈR[h
	public static final String COL_RT_CODE		= "RTCODE"		;	//[gR[h
	public static final String COL_DELETE_FLAG	= "DELETEFLAG"	;	//폜tO

	/**
	 * RXgN^
	 */
	public PmHolidayRequestDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<PmHolidayRequestDto> mappingAll() throws SQLException {
		List<PmHolidayRequestDto> all = new ArrayList<PmHolidayRequestDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return PmHolidayrequestDto pm_holidayrequestR[h
	 * @throws SQLException
	 */
	private PmHolidayRequestDto mapping() throws SQLException {
		PmHolidayRequestDto dto = new PmHolidayRequestDto();
		dto.setRouteId		(rs.getInt		(COL_ROUTE_ID)		);		//[gID
		dto.setSCode		(rs.getString	(COL_S_CODE)		);		//R[h
		dto.setKCode		(rs.getString	(COL_K_CODE)		);		//ЈR[h
		dto.setRtCode		(rs.getString	(COL_RT_CODE)		);		//[gR[h
		dto.setDeleteFlag	(rs.getInt		(COL_DELETE_FLAG)	);		//폜tO
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PmHolidayRequestDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<PmHolidayRequestDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param routeid [gID(L[)
	 * @return PmHolidayrequestDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmHolidayRequestDto findForKey(
			int     routeid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, routeid);
			executeQuery();
			PmHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param routeid [gID(L[)
	 * @return PmHolidayrequestDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public PmHolidayRequestDto findForUpdate(
			String routeid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, routeid);
			executeQuery();
			PmHolidayRequestDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param routeid [gID
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String routeid
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_ROUTE_ID);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   routeid  );
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(PmHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}


	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(PmHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getRouteId());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(PmHolidayRequestDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getRouteId());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(PmHolidayRequestDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getRouteId());	//[gID
		setParam(index++, dto.getSCode());		//R[h
		setParam(index++, dto.getKCode());		//ЈR[h
		setParam(index++, dto.getRtCode());		//[gR[h
		setParam(index++, dto.getDeleteFlag());	//폜tO
		setCommonParams(isInsert);
	}

}
